import json
import time
import random
from concurrent.futures import ThreadPoolExecutor as TPE, as_completed
from threading import Thread
from windows import create_window
from caches.providers_cache import ExternalProvidersCache
from modules import kodi_utils, source_utils
from modules.debrid import DebridCheck
from modules.utils import clean_file_name
from modules.settings import display_sleep_time
# logger = kodi_utils.logger

ls, sleep, monitor, get_setting = kodi_utils.local_string, kodi_utils.sleep, kodi_utils.monitor, kodi_utils.get_setting
get_property, set_property, clear_property = kodi_utils.get_property, kodi_utils.set_property, kodi_utils.clear_property
notification, hide_busy_dialog, progressDialogBG = kodi_utils.notification, kodi_utils.hide_busy_dialog, kodi_utils.progressDialogBG
get_filename_match, get_file_info = source_utils.get_filename_match, source_utils.get_file_info
normalize, sources_quality_count = source_utils.normalize, source_utils.sources_quality_count
pack_display, format_line, total_format = '%s (%s)', '%s[CR]%s[CR]%s', '[COLOR %s][B]%s[/B][/COLOR]'
int_format, ext_format = '[COLOR %s][B]Int: [/B][/COLOR]%s', '[COLOR %s][B]Ext: [/B][/COLOR]%s'
ext_scr_format, unfinshed_import_format = '[COLOR %s][B]%s[/B][/COLOR]', '[COLOR red]+%s[/COLOR]'
diag_format, resolutions = '4K: %s | 1080p: %s | 720p: %s | SD: %s | Total: %s', '4K 1080p 720p SD total'
season_display, show_display = ls(32537), ls(32089)
pack_check = (season_display, show_display)

class Manager:
	def dialog_hook(function):
		def wrapper(instance, *args, **kwargs):
			if not instance.background:
				hide_busy_dialog()
				if not instance.progress_dialog and not instance.full_screen:
					progressDialogBG.create('POV', 'POV loading...')
				else: instance._make_progress_dialog()
			result = function(instance, *args, **kwargs)
			if not instance.background:
				if not instance.progress_dialog and not instance.full_screen:
					progressDialogBG.close()
				else: instance._kill_progress_dialog()
			return result
		return wrapper

	def __init__(self, meta, source_dict, debrid_torrents, debrid_hosters, internal_scrapers, prescrape_sources, display_uncached_torrents, progress_dialog, disabled_ignored=False):
		self.meta = meta
		self.background, self.full_screen = self.meta.get('background', False), self.meta.get('full_screen', False)
		self.debrid_torrents, self.debrid_hosters = debrid_torrents, debrid_hosters
		self.source_dict, self.hostDict = source_dict, self.make_host_dict()
		self.internal_scrapers, self.prescrape_sources = internal_scrapers, prescrape_sources
		self.display_uncached_torrents = display_uncached_torrents
		self.disabled_ignored, self.progress_dialog = disabled_ignored, progress_dialog
		self.internal_activated, self.internal_prescraped = len(self.internal_scrapers) > 0, len(self.prescrape_sources) > 0
		self.processed_prescrape = False
		self.processed_internal_scrapers, self.sources, self.final_sources = [], [], []
		self.processed_internal_scrapers_append = self.processed_internal_scrapers.append
		self.sleep_time = display_sleep_time()
		self.timeout = int(self.meta.get('scrape_timeout', '10')) - 1
		self.int_dialog_highlight = get_setting('int_dialog_highlight', 'dodgerblue')
		self.ext_dialog_highlight = get_setting('ext_dialog_highlight', 'magenta')
		self.finish_early = get_setting('search.finish.early')
		self.int_total, self.ext_total = total_format % (self.int_dialog_highlight, '%s'), total_format % (self.ext_dialog_highlight, '%s')
		self.internal_resolutions, self.resolutions = dict.fromkeys(resolutions.split(), 0), dict.fromkeys(resolutions.split(), 0)

	@dialog_hook
	def results(self, info):
		ExternalSource.resolutions, ExternalSource.timeout = self.resolutions, self.timeout
		tpe = TPE(max(1, len(self.source_dict), len(self.debrid_torrents)))
		self.threads = set()
		try:
			random.shuffle(self.source_dict)
			# shuffle because tpe returns order submitted without as_completed
			# chose not to use as_completed because status monitored by done and absolute scrape timeout
			for provider, module, *pack in self.source_dict:
				args = (provider, module, *pack) if pack else (provider, module)
				fut = tpe.submit(ExternalSource(self.meta, args=args).results, info)
				fut.name = pack_display % (provider, *pack) if pack and pack[0] else provider
				self.threads.add(fut)
			self.wait()
			self.sources.extend(i for fut in self.threads for i in (fut.result() if fut.done() else []))
			self.sources = self.process_duplicates(self.sources)
			torrent_sources = [i for i in self.sources if 'hash' in i]
			result_hashes = list({i['hash'] for i in torrent_sources})
			DebridCheck.set_cached_hashes(result_hashes)
			self.threads = set()
			for item in self.debrid_torrents:
				fut = tpe.submit(DebridCheck(self.meta, item).cache_check)
				fut.name = item
				self.threads.add(fut)
			self.wait(debrid_check=True)
			for name, hashes in ((fut.name, fut.result() if fut.done() else []) for fut in self.threads):
				status = ('Unchecked %s' if name in ('real-debrid', 'alldebrid') else 'Uncached %s') % name
				self.final_sources.extend([{**i, 'cache_provider': name, 'debrid': name} for i in torrent_sources if i['hash'] in hashes])
				self.final_sources.extend([{**i, 'cache_provider': status, 'debrid': name} for i in torrent_sources if not i['hash'] in hashes])
			self.final_sources = [i for i in self.final_sources if not (i['source'] == 'usenet' and 'Unchecked' in i['cache_provider'])]
			hoster_sources = [i for i in self.sources if not 'hash' in i]
			result_hosters = list({i['source'].lower() for i in hoster_sources})
			for item in self.debrid_hosters:
				for k, v in item.items():
					valid_hosters = [i for i in result_hosters if i in v]
					self.final_sources.extend([{**i, 'debrid': k} for i in hoster_sources if i['source'] in valid_hosters])
		except: notification(32574)
		finally: tpe.shutdown(False)
		return self.final_sources

	def wait(self, debrid_check=False):
		if not self.background:
			if self.internal_activated or self.internal_prescraped:
				string3 = int_format % (self.int_dialog_highlight, '%s')
				string4 = ext_format % (self.ext_dialog_highlight, '%s')
			else: string4 = ext_scr_format % (self.ext_dialog_highlight, ls(32118))
			string1, string2 = ls(32579) if debrid_check else ls(32676), ls(32677)
			line1 = line2 = line3 = ''
		len_threads = len(self.threads)
		end_time = time.monotonic() + self.timeout
		while alive_threads := [x.name for x in self.threads if not x.done()]:
			if monitor.abortRequested() or time.monotonic() > end_time: break
			if not self.background:
				try:
					if self.progress_dialog and self.progress_dialog.iscanceled(): break
					ext_totals = [self.ext_total % v for v in self.resolutions.values()]
					len_alive_threads = len(alive_threads)
					progress = int((len_threads-len_alive_threads)/len_threads*100)
					if self.internal_activated or self.internal_prescraped:
						alive_threads.extend(self.process_internal_results())
						int_totals = [self.int_total % v for v in self.internal_resolutions.values()]
						line1 = string3 % diag_format % tuple(int_totals)
						line2 = string4 % diag_format % tuple(ext_totals)
					else:
						line1 = string4
						line2 = diag_format % tuple(ext_totals)
					if len_alive_threads > 5: line3 = string1 % str(len_threads-len_alive_threads)
					else: line3 = string1 % ', '.join(alive_threads).upper()
					if self.progress_dialog: self.progress_dialog.update(format_line % (line1, line2, line3), progress)
					else: progressDialogBG.update(progress, line3)
					finish_early = debrid_check is False and self.finish_early and len(self.sources) > len_threads // 0.1
					if finish_early: break
				except: pass
			sleep(self.sleep_time)

	def process_duplicates(self, sources):
		def _process():
			uniqueURLs, uniqueHashes = set(), set()
			for provider in sources:
				try:
					url = provider['url'].lower()
					if url in uniqueURLs: continue
					uniqueURLs.add(url)
					if 'hash' in provider:
						_hash = provider['hash'].lower()
						if _hash in uniqueHashes: continue
						uniqueHashes.add(_hash)
						yield provider
					else: yield provider
				except: yield provider
		return list(_process())

	def process_internal_results(self):
		def _process_quality_count(sources):
			for k in self.internal_resolutions: self.internal_resolutions[k] += sources.get(k, 0)
		if self.internal_prescraped and not self.processed_prescrape:
			_process_quality_count(sources_quality_count(self.prescrape_sources))
			self.processed_prescrape = True
		for i in self.internal_scrapers:
			win_property = get_property('%s.internal_results' % i)
			if win_property in ('checked', '', None): continue
			try: internal_sources = json.loads(win_property)
			except: continue
			set_property('%s.internal_results' % i, 'checked')
			self.processed_internal_scrapers_append(i)
			_process_quality_count(internal_sources)
		return [i for i in self.internal_scrapers if not i in self.processed_internal_scrapers]

	def make_host_dict(self):
		pr_list = []
		pr_list_extend = pr_list.extend
		for item in self.debrid_hosters:
			for k, v in item.items(): pr_list_extend(v)
		return list(set(pr_list))

	def _make_progress_dialog(self):
		if self.progress_dialog: return
		self.progress_dialog = create_window(('windows.sources', 'ProgressMedia'), 'progress_media.xml', meta=self.meta)
		Thread(target=self.progress_dialog.run).start()

	def _kill_progress_dialog(self):
		try: self.progress_dialog.close()
		except: pass
		try: del self.progress_dialog
		except: pass
		self.progress_dialog = None

class ExternalSource:
	def __init__(self, meta, args):
		self.sources = []
		self.meta, self.args = meta, args

	def results(self, info):
		try:
			self.media_type, self.tmdb_id, self.year = info['media_type'], str(info['tmdb_id']), info['year']
			self.season, self.episode, self.total_seasons = info['season'], info['episode'], info['total_seasons']
			self.title, self.orig_title, aliases = normalize(info['title']), info['title'], info['aliases']
			self.single_expiry, self.season_expiry, self.show_expiry = info['expiry_times']
			if self.media_type == 'episode':
				season_divider = (
					x['episode_count'] for x in self.meta['season_data'] if int(x['season_number']) == int(self.meta['season'])
				)
				self.season_divider, self.show_divider = int(next(season_divider, 1)), int(self.meta['total_aired_eps'])
				self.data = {
					'timeout': self.timeout, 'imdb': info['imdb_id'], 'tvdb': info['tvdb_id'], 'aliases': aliases,
					'title': normalize(info['ep_name']), 'tvshowtitle': self.title, 'year': self.year,
					'season': str(self.season), 'episode': str(self.episode), 'total_seasons': self.total_seasons
				}
				self.get_episode_source(*self.args)
			else:
				self.season_divider, self.show_divider = 1, 1
				self.data = {
					'timeout': self.timeout, 'imdb': info['imdb_id'], 'aliases': aliases,
					'title': self.title, 'year': self.year
				}
				self.get_movie_source(*self.args)
		except: pass
		return self.sources

	def get_movie_source(self, provider, module):
		_cache = ExternalProvidersCache()
		sources = _cache.get(provider, self.media_type, self.tmdb_id, self.title, self.year, '', '')
		if sources is None:
			sources = module().sources(self.data, self.hostDict)
			sources = self.process_sources(provider, sources)
			_cache.set(provider, self.media_type, self.tmdb_id, self.title, self.year, '', '', sources, self.single_expiry)
		if sources:
			self.sources.extend(sources)

	def get_episode_source(self, provider, module, pack):
		if pack in pack_check: s_check, e_check = '' if pack == show_display else self.season, ''
		else: s_check, e_check = self.season, self.episode
		_cache = ExternalProvidersCache()
		sources = _cache.get(provider, self.media_type, self.tmdb_id, self.title, self.year, s_check, e_check)
		if sources is None:
			if pack == show_display:
				expiry_hours = self.show_expiry
				sources = module().sources_packs(self.data, self.hostDict, search_series=True, total_seasons=self.total_seasons)
			elif pack == season_display:
				expiry_hours = self.season_expiry
				sources = module().sources_packs(self.data, self.hostDict)
			else:
				expiry_hours = self.single_expiry
				sources = module().sources(self.data, self.hostDict)
			sources = self.process_sources(provider, sources)
			_cache.set(provider, self.media_type, self.tmdb_id, self.title, self.year, s_check, e_check, sources, expiry_hours)
		if sources:
			if pack == season_display: sources = [i for i in sources if not 'episode_start' in i or i['episode_start'] <= self.episode <= i['episode_end']]
			elif pack == show_display: sources = [i for i in sources if i['last_season'] >= self.season]
			self.sources.extend(sources)

	def process_sources(self, provider, sources):
		try:
			for i in sources:
				try:
					i_get = i.get
					if 'hash' in i: i['hash'] = str(i['hash']).lower()
					size, size_label, divider = 0, None, None
					if 'name' in i: URLName = clean_file_name(i_get('name')).replace('html', ' ').replace('+', ' ').replace('-', ' ')
					else: URLName = get_filename_match(self.orig_title, i_get('url'), i_get('name'))
					if 'name_info' in i: quality, extraInfo = get_file_info(name_info=i_get('name_info'))
					else: quality, extraInfo = get_file_info(url=i_get('url'))
					try:
						size = i_get('size')
						if 'package' in i and not i_get('true_size', False):
							if i_get('package') == 'season': divider = self.season_divider
							else: divider = self.show_divider
							size = float(size) / divider
							size_label = '%.2f GB' % size
						else: size_label = '%.2f GB' % size
					except: pass
					i.update({
						'external': True, 'provider': provider, 'scrape_provider': self.scrape_provider, 'URLName': URLName,
						'extraInfo': extraInfo, 'quality': quality, 'size_label': size_label, 'size': round(size, 2)
					})
					if not quality in self.resolutions: self.resolutions['SD'] += 1
					else: self.resolutions[quality] += 1
					self.resolutions['total'] += 1
				except: pass
		except: pass
		return sources

	scrape_provider = 'external'
	timeout = 10
	hostDict = {}
	resolutions = dict.fromkeys(resolutions.split(), 0)

