# -*- coding: utf-8 -*-
# -*- Channel DonTorrent -*-
# -*- Created for Alfa-addon -*-
# -*- By the Alfa Develop Group -*-

import sys
PY3 = False
if sys.version_info[0] >= 3: PY3 = True; unicode = str; unichr = chr; long = int; _dict = dict

from lib import AlfaChannelHelper
if not PY3: _dict = dict; from AlfaChannelHelper import dict
from AlfaChannelHelper import DictionaryAllChannel
from AlfaChannelHelper import re, traceback, time, base64, xbmcgui
from AlfaChannelHelper import Item, servertools, scrapertools, jsontools, get_thumb, config, logger, filtertools, autoplay, renumbertools

IDIOMAS = AlfaChannelHelper.IDIOMAS_T
list_language = list(set(IDIOMAS.values()))
list_quality_movies = AlfaChannelHelper.LIST_QUALITY_MOVIES_T
list_quality_tvshow = AlfaChannelHelper.LIST_QUALITY_TVSHOW
list_quality = list_quality_movies + list_quality_tvshow
list_servers = AlfaChannelHelper.LIST_SERVERS_T
forced_proxy_opt = 'ProxySSL'
# Lista de proxies: https://donproxies.com/

canonical = {
             'channel': 'dontorrent', 
             'host': config.get_setting("current_host", 'dontorrent', default=''), 
             'host_alt': ["https://dontorrent.prof/", "https://lilatorrent.com/", "https://todotorrents.org/", "https://elitedivx.net/"], 
             'host_alt_new': ["https://dontorrent.prof/"], 
             'host_black_list': ["https://dontorrent.club/", "https://www21.dontorrent.link/", 
                                 "https://dontorrent.sarl/", "https://dontorrent.gripe/", "https://reinventorrent.org/", 
                                 "https://dontorrent.phd/", "https://dontorrent.live/", "https://dontorrent.kiwi/", 
                                 "https://dontorrent.kids/", "https://dontorrent.onl/", "https://dontorrent.istanbul/", 
                                 "https://dontorrent.lighting/", "https://dontorrent.irish/", "https://dontorrent.international/", 
                                 "https://dontorrent.graphics/", "https://www20.dontorrent.link/", "https://dontorrent.loan/", 
                                 "https://www19.dontorrent.link/", "https://dontorrent.jetzt/", "https://dontorrent.institute/", 
                                 "https://dontorrent.news/", "https://dontorrent.haus/", "https://dontorrent.homes/", 
                                 "https://dontorrent.report/", "https://dontorrent.gift/", "https://dontorrent.download/", 
                                 "https://mastorrents.net/", "https://dontorrent.group/", "https://dontorrent.website/",
                                 "https://dontorrent.stream/", "https://dontorrent.schule/", "https://www18.dontorrent.link/", 
                                 "https://dontorrent.webcam/", "https://dontorrent.trade/", "https://dontorrent.tube/", 
                                 "https://dontorrent.games/", "https://dontorrent.wiki/", "https://dontorrent.football/", 
                                 "https://dontorrent.auction/", "https://dontorrent.co/", "https://dontorrent.foundation/", 
                                 "https://www17.dontorrent.link/", "https://dontorrent.yoga/", "https://tomadivx.net/", 
                                 "https://dontorrent.gallery/", "https://www16.dontorrent.link/", "https://dontorrent.fashion/", 
                                 "https://dontorrent.equipment/", "https://www15.dontorrent.link/", "https://dontorrent.gratis/", 
                                 "https://www15.dontorrent.link/", "https://dontorrent.faith/", "https://dontorrent.exposed/", 
                                 "https://dontorrent.education/", "https://dontorrent.email/", "https://dontorrent.date/", 
                                 "https://dontorrent.earth/", "https://dontorrent.cricket/", "https://dontorrent.dance/", 
                                 "https://dontorrent.cologne/", "https://dontorrent.city/", "https://dontorrent.esq/", 
                                 "https://dontorrent.cc/", "https://dontorrent.sbs/", "https://dontorrent.fyi/", 
                                 "https://dontorrent.icu/", "https://dontorrent.clothing/", "https://dontorrent.business/", 
                                 "https://dontorrent.miami/", "https://dontorrent.boutique/", "https://dontorrent.directory/", 
                                 "https://dontorrent.skin/", "https://dontorrent.agency/", "https://www2.dontorrent.fr/", 
                                 "https://dontorrent.cyou/", "https://dontorrent.cooking/", "https://dontorrent.center/", 
                                 "https://dontorrent.band/", "https://dontorrent.makeup/", "https://dontorrent.yokohama/", 
                                 "https://dontorrent.capetown/", "https://dontorrent.cymru/", "https://dontorrent.contact/", 
                                 "https://dontorrent.nagoya/", "https://dontorrent.wales/", "https://dontorrent.joburg/", 
                                 "https://dontorrent.party/", "https://dontorrent.durban/", "https://dontorrent.rodeo/",
                                 "https://dontorrent.boston/", "https://dontorrent.tokyo/", "https://dontorrent.bond/",
                                 'https://dontorrent.nexus/', "https://dontorrent.quest/", "https://dontorrent.rsvp/", "https://dontorrent.hair/", 
                                 "https://dontorrent.foo/", "https://dontorrent.boo/", "https://dontorrent.day/", 
                                 "https://dontorrent.mov/", 'https://dontorrent.zip/', 'https://dontorrent.dad/', 
                                 'https://dontorrent.discount/', 'https://dontorrent.company/', 'https://dontorrent.observer/', 
                                 'https://dontorrent.cash/', 'https://dontorrent.care/', 'https://dontorrent.ms/', 
                                 'https://dontorrent.pictures/', 'https://dontorrent.cloud/', 'https://dontorrent.africa/', 
                                 'https://dontorrent.love/', 'https://dontorrent.ninja/', 'https://dontorrent.plus/', 
                                 'https://dontorrent.chat/', 'https://dontorrent.casa/', 'https://dontorrent.how/', 
                                 'https://dontorrent.surf/', 'https://dontorrent.beer/', 'https://dontorrent.blue/', 
                                 'https://dontorrent.army/', 'https://dontorrent.mba/', 'https://dontorrent.futbol/', 
                                 'https://dontorrent.fail/', 'https://dontorrent.click/', 'https://dontorrent.gy/',
                                 'https://dontorrent.gs/', 'https://dontorrent.me/', 'https://dontorrent.ltd/', 
                                 'https://dontorrent.fans/', 'https://dontorrent.uno/', 'https://dontorrent.ist/', 
                                 'https://dontorrent.vin/', 'https://dontorrent.tf/', 'https://dontorrent.pub/', 
                                 'https://dontorrent.moe/', 'https://dontorrent.soy/', 'https://dontorrent.pet/', 
                                 'https://dontorrent.bid/', 'https://dontorrent.dev/', 'https://dontorrent.dog/', 
                                 'https://dontorrent.vet/', 'https://dontorrent.ch/', 'https://dontorrent.vg/', 
                                 'https://dontorrent.yt/', 'https://dontorrent.tw/', 'https://dontorrent.kim/', 
                                 'https://dontorrent.ink/', 'https://dontorrent.fi/', 'https://dontorrent.wtf/', 
                                 'https://dontorrent.cab/', 'https://dontorrent.bet/', 'https://dontorrent.cx/', 
                                 'https://dontorrent.nl/', 'https://dontorrent.tel/', 'https://dontorrent.pl/', 
                                 'https://dontorrent.cat/', 'https://dontorrent.run/', 'https://dontorrent.wf/', 
                                 'https://dontorrent.pm/', 'https://dontorrent.top/', "https://dontorrent.re/",
                                 "https://todotorrents.net/", "https://verdetorrent.com/", "https://dontorrent.in/"], 
             'pattern_proxy': r'<a[^>]*class="text-white[^"]+"\s*style="font-size[^"]+"\s*href="([^"]+)"[^>]*>\s*Descargar\s*<\/a>', 
             'proxy_url_test': 'pelicula/25159/The-Batman', 
             'set_tls': True, 'set_tls_min': True, 'retries_cloudflare': 1, 'forced_proxy_ifnot_assistant': forced_proxy_opt, 
             'CF': False, 'CF_test': False, 'alfa_s': True, 'renumbertools': False
            }
host = canonical['host'] or canonical['host_alt'][0]
channel = canonical['channel']
categoria = channel.capitalize()
host_new = True if canonical['host'] in canonical.get('host_alt_new', []) else False
domain_torrent = 'dontorrent.foo'
host_torrent = host if 'dontorrent' in host and not '.in/' in host else ''
host_torrent_referer = host
modo_ultima_temp = config.get_setting('seleccionar_ult_temporadda_activa', channel)     # Actualización sólo últ. Temporada?
min_temp = modo_ultima_temp if not modo_ultima_temp else 'continue'

timeout = (5, config.get_setting('timeout_downloadpage', channel))
kwargs = {}
debug = config.get_setting('debug_report', default=False)
movie_path = "/pelicula"
tv_path = '/serie'
docu_path = '/documental'
tienda_path = '/tienda'
torrent_path = 'api_validate_pow.php'
language = ['CAST']
url_replace = []

finds = {'find': {'find_all': [{'tag': ['div'], 'class': ['text-center']}]}, 
         'sub_menu': dict([('find', [{'tag': ['div'], 'class': ['torrents-list']}]), 
                           ('find_all', [{'tag': ['a']}])]), 
         'categories': {},  
         'search': {}, 
         'get_language': {}, 
         'get_language_rgx': '', 
         'get_quality': {}, 
         'get_quality_rgx': [], 
         'next_page': {}, 
         'next_page_rgx': [[r'\/page\/\d+', '/page/%s'], [r'&pagina=\d+', '&pagina=%s']], 
         'last_page': dict([('find', [{'tag': ['ul'], 'class': ['pagination']}]), 
                            ('find_all', [{'tag': ['a'], '@POS': [-2]}]), 
                            ('get_text', [{'tag': '', '@STRIP': True, '@TEXT': r'(\d+)'}])]), 
         'year': {}, 
         'season_episode': {}, 
         'seasons': {},
         'season_num': dict([('find', [{'tag': ['a']}]), 
                             ('get_text', [{'tag': '', '@STRIP': True, '@TEXT': r'(\d+)'}])]), 
         'seasons_search_num_rgx': [[r'(?i)-(\d+)-(?:Temporada|Miniserie)', None], [r'(?i)(?:Temporada|Miniserie)-(\d+)(?:\W|$)', None]], 
         'seasons_search_qty_rgx': [[r'(?i)(?:Temporada|Miniserie)(?:-(.*?)(?:\.|\/|-$|$))', None]], 
         'episode_url': '', 
         'episodes': dict([('find', [{'tag': ['div'], 'class': ['card shadow-sm p-4']}]), 
                           ('find_all', [{'tag': ['tr']}])]), 
         'episode_num': [], 
         'episode_clean': [], 
         'plot': {}, 
         'findvideos': {'find_all': [{'tag': ['div'], 'class': ['card shadow-sm p-4']}]}, 
         'title_clean': [[r'(?i)TV|Online|(4k-hdr)|(fullbluray)|4k| - 4k|(3d)|miniserie|\s*imax|documental|completo', ''],
                         [r'(?i)[\[|\(]?\d{3,4}p[\]|\)]?|[\[|\(]?(?:4k|3d|uhd|hdr)[\]|\)]?', ''], 
                         [r'(?i)[-|\(]?\s*HDRip\)?|microHD|\(?BR-LINE\)?|\(?HDTS-SCREENER\)?', ''], 
                         [r'(?i)\(?BDRip\)?|\(?BR-Screener\)?|\(?DVDScreener\)?|\(?TS-Screener\)?|[\(|\[]\S*\.*$', ''],
                         [r'(?i)Castellano-*|Ingl.s|Trailer|Audio|\(*SBS\)*|\[*\(*dvd\s*r\d*\w*\]*\)*|[\[|\(]*dv\S*[\)|\]]*', ''], 
                         [r'(?i)Dual|Subt\w*|\(?Reparado\)?|\(?Proper\)?|\(?Latino\)?|saga(?:\s*del)?|\s+final', ''], 
                         [r'(?i)\s+\[*sub.*.*\s*int\w*\]*|poster', ''], 
                         [r'(?i)(?:\s*&#8211;)?\s*temp.*?\d+.*', ''], [r'\d?\d?&#.*', ''], [r'\d+[x|×]\d+.*', ''], 
                         [r'[\(|\[]\s*[\)|\]]', ''], [r'(?i)\s*-\s*\d{1,2}[^t]*\s*temp\w*\s*(?:\[.*?\])?', '']],
         'quality_clean': [[r'(?i)proper|unrated|directors|cut|repack|internal|real|extended|masted|docu|super|duper|amzn|uncensored|hulu', '']],
         'language_clean': [], 
         'url_replace': [], 
         'controls': {'min_temp': min_temp, 'url_base64': True, 'add_video_to_videolibrary': True, 'cnt_tot': 15, 
                      'get_lang': False, 'reverse': False, 'videolab_status': True, 'tmdb_extended_info': True, 'seasons_search': True, 
                      'host_torrent': host_torrent, 'btdigg': True, 'btdigg_search': True, 'duplicates': [], 'dup_list': 'title', 
                      'force_find_last_page': [5, 999, 'url'], 'btdigg_quality_control': True},
         'timeout': timeout}
AlfaChannel = DictionaryAllChannel(host, movie_path=movie_path, tv_path=tv_path, canonical=canonical, finds=finds, 
                                   idiomas=IDIOMAS, language=language, list_language=list_language, list_servers=list_servers, 
                                   list_quality_movies=list_quality_movies, list_quality_tvshow=list_quality_tvshow, 
                                   channel=canonical['channel'], actualizar_titulos=True, url_replace=url_replace, debug=debug)


def mainlist(item):
    logger.info()

    itemlist = []

    autoplay.init(item.channel, list_servers, list_quality)
    
    itemlist.append(Item(channel=item.channel, title="Novedades", action="submenu", 
                         url=host, thumbnail=get_thumb("now_playing.png"), c_type="novedades", 
                         category=categoria))
    
    itemlist.append(Item(channel=item.channel, title="Películas", action="submenu", 
                         url=host, thumbnail=get_thumb("channels_movie.png"), c_type="peliculas", 
                         category=categoria))

    itemlist.append(Item(channel=item.channel, title="Series", action="submenu", 
                         url=host, thumbnail=get_thumb("channels_tvshow.png"), c_type="series", 
                         category=categoria))

    itemlist.append(Item(channel=item.channel, title="Documentales", action="submenu", 
                         url=host, thumbnail=get_thumb("channels_documentary.png"), c_type="series", 
                         category=categoria))

    itemlist.append(Item(channel=item.channel, title="Buscar...", action="search", 
                         url=host, thumbnail=get_thumb("search.png"), c_type="search", 
                         category=categoria))

    if config.get_setting('find_alt_search', channel):
        itemlist.append(Item(channel=item.channel, title=config.BTDIGG_LABEL + " búsqueda... (Pelis y Series)", action="search", 
                             url=host, thumbnail=get_thumb("search.png"), c_type="search", 
                             category=categoria, plot=AlfaChannelHelper.PLOT_BTDIGG, btdigg=True))

    itemlist.append(Item(channel=item.channel, url=host, title="[COLOR yellow]Configuración:[/COLOR]", 
                         folder=False, thumbnail=get_thumb("next.png")))
    itemlist.append(Item(channel=item.channel, action="configuracion", title="Configurar canal", 
                         thumbnail=get_thumb("setting_0.png")))

    itemlist = renumbertools.show_option(item.channel, itemlist, status=canonical.get('renumbertools', False))

    itemlist = filtertools.show_option(itemlist, item.channel, list_language, list_quality_tvshow, list_quality_movies)
    
    autoplay.show_option(item.channel, itemlist)

    return itemlist
    
    
def configuracion(item):
    from platformcode import platformtools

    ret = platformtools.show_channel_settings()

    return platformtools.itemlist_refresh()


def submenu(item):
    global host_new
    logger.info()

    itemlist = []
    findS = finds.copy()

    if item.c_type == "novedades":

        for novedad, contentType, c_type in [['Películas', 'movie', 'peliculas'], 
                                             ['Series', 'tvshow', 'series'], 
                                             ['Documentales', 'documentary', 'series']]:

            itemlist.append(Item(channel=item.channel, title=novedad, action="list_all", 
                                 url=host + "ultimos", thumbnail=get_thumb("channels_%s.png" % contentType), 
                                 c_type=c_type, extra="novedades", category=categoria))

        itemlist.append(Item(channel=item.channel, title='Buscar...', action="search", 
                             url=host, thumbnail=get_thumb("search.png"), 
                             c_type="search", category=categoria))

        if config.get_setting('find_alt_search', channel):
            itemlist.append(Item(channel=item.channel, title=config.BTDIGG_LABEL + " búsqueda... (Pelis y Series)", action="search", 
                                 url=host, thumbnail=get_thumb("search.png"), c_type="search", 
                                 category=categoria, plot=AlfaChannelHelper.PLOT_BTDIGG, btdigg=True))

        itemlist.append(Item(channel=item.channel, action="configuracion", title="Configurar canal", 
                             thumbnail=get_thumb("setting_0.png")))
        itemlist = renumbertools.show_option(item.channel, itemlist, status=canonical.get('renumbertools', False))
        itemlist = filtertools.show_option(itemlist, item.channel, list_language, list_quality_tvshow, list_quality_movies)

        return itemlist

    soup = AlfaChannel.create_soup(host, **kwargs)
    matches_int = AlfaChannel.parse_finds_dict(soup, findS['sub_menu'])
    host_new = True if canonical['host'] in canonical.get('host_alt_new', []) else False

    # En películas las categorías se llaman con Post
    post_alfabeto = 'campo=letra&valor3=%s&valor=&valor2=&pagina=1'
    post_anno = 'campo=anyo&valor=%s&valor2=&valor3=&valor4=&pagina=1'
    post_genero = 'campo=genero&valor3=&valor=&valor2=%s&pagina=1'
    post_calidad = 'campo=tiporip&valor3=&valor=&valor2=&valor5=%s&pagina=1'

    if not matches_int:
        return itemlist

    for elem in matches_int:
        #logger.error(elem)

        title = '[B]%s[/B]' % elem.get_text('|', strip=True).split('|')[0].title()
        url = AlfaChannel.urljoin(host, elem.get('href', '')).strip()
        contentType = 'movie' if item.c_type == "peliculas" else 'documentary' if item.title == "Documentales" else 'tvshow'
        if contentType == 'movie':
            quality = 'HD' if 'hd' in title.lower() or '4k' in title.lower() else ''
        else:
            quality = 'HDTV-720p' if 'hd' in title.lower() else '' if item.title == "Documentales" else 'HDTV'

        if item.title in title:
            if 'descargar-' in url: 
                url = url.replace('descargar-', '')
            itemlist.append(Item(channel=item.channel, title=title, action="list_all", 
                                 url=url+'/page/1', thumbnail=get_thumb("channels_%s%s.png" % (contentType, '_hd' if quality else '')), 
                                 c_type=item.c_type, quality=quality, category=categoria))

            if item.c_type != 'peliculas' and not host_new:                     # Para todo, menos películas
                itemlist.append(Item(channel=item.channel, title=' - [COLOR paleturquoise]Por [A-Z][/COLOR]', action="section", 
                                     url=url + "/letra-%s/page/1", thumbnail=get_thumb('channels_movie_az.png'), c_type=item.c_type, 
                                     extra='Alfabético', quality=quality, category=categoria))

            elif title == '[B]Películas[/B]':                                   # Categorías sólo de películas
                itemlist.append(Item(channel=item.channel, title=' - [COLOR paleturquoise]Por [A-Z][/COLOR]', action="section", 
                                     url=url + "/buscar", thumbnail=get_thumb('channels_movie_az.png'), c_type=item.c_type, 
                                     extra='Alfabético', quality=quality, category=categoria, post=post_alfabeto))

                itemlist.append(Item(channel=item.channel, title=' - [COLOR paleturquoise]Por Género[/COLOR]', action="section", 
                                     url=url+'/page/1', thumbnail=get_thumb('genres.png'), c_type=item.c_type, 
                                     extra='Géneros', category=categoria, info=[url + "/buscar", post_genero, 'valor2']))

                itemlist.append(Item(channel=item.channel, title=' - [COLOR paleturquoise]Por Año[/COLOR]', action="section", 
                                     url=url + "/buscar", thumbnail=get_thumb('years.png'), c_type=item.c_type, 
                                     extra='Year', category=categoria, post=post_anno))

                itemlist.append(Item(channel=item.channel, title=' - [COLOR paleturquoise]Por Calidad[/COLOR]', action="section", 
                                     url=url+'/page/1', thumbnail=get_thumb('search_star.png'), c_type=item.c_type, 
                                     extra='Quality', category=categoria, info=[url + "/buscar", post_calidad, 'valor5']))

    return itemlist


def section(item):
    logger.info()

    findS = finds.copy()

    if item.extra == "Alfabético":
        itemlist = []

        for letra in ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 
                      'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z']:
            
            if item.c_type != 'peliculas':
                itemlist.append(item.clone(action="list_all", title=letra, url=item.url % letra.lower()))
            else:
                itemlist.append(item.clone(action="list_all", title=letra, post=item.post % letra))

        return itemlist
    
    if item.extra == "Year":
        from platformcode.platformtools import dialog_numeric
        
        year = dialog_numeric(0, "Introduzca el Año de búsqueda", default="")
        item.post = item.post % year
        
        return list_all(item)

    findS['categories'] = dict([('find', [{'tag': ['select'], 'name': item.info[2]}]), 
                                ('find_all', [{'tag': ['option']}])])

    return AlfaChannel.section(item, matches_post=section_matches, finds=findS, **kwargs)


def section_matches(item, matches_int, **AHkwargs):
    logger.info()

    matches = []
    findS = AHkwargs.get('finds', finds)

    for elem in matches_int:
        elem_json = {}
        #logger.error(elem)

        elem_json['url'] = item.info[0]
        elem_json['title'] = elem.get_text(strip=True)
        elem_json['post'] = item.info[1] % elem_json['title'].replace(' ', '+')
        elem_json['c_type'] = item.c_type

        matches.append(elem_json.copy())

    return matches


def list_all(item):
    logger.info()
    
    findS = finds.copy()
    kwargs['headers'] = {'Referer': item.url}
    
    if item.extra in ['novedades']:
        findS['find'] = {'find_all': [{'tag': ['div'], 'class': ['card shadow-sm p-2', 'card shadow-sm']}]}
        
        findS['last_page'] = {}
        if findS['controls'].get('force_find_last_page'): del findS['controls']['force_find_last_page']
        if 'Documentales' in item.title: findS['controls']['btdigg'] = False
    
    elif item.extra in ['Alfabético', 'Géneros', 'Year', 'Quality'] and item.c_type == 'peliculas':
        findS['find'] = {'find_all': [{'tag': ['div'], 'class': ['card shadow-sm p-3 mt-3']}]}

        findS['last_page'] = dict([('find', [{'tag': ['select'], 'name': ['pagina']}]), 
                                   ('find_all', [{'tag': ['option'], '@POS': [-1], '@ARG': 'value'}])])
        findS['controls'].update({'force_find_last_page': ['', '', 'post']})

    elif item.extra in ['Alfabético'] and item.c_type == 'series':
        findS['find'] = {'find_all': [{'tag': ['div'], 'class': ['card shadow-sm p-4 mt-3']}]}

    elif item.c_type == 'search':
        findS['find'] = {'find_all': [{'tag': ['div'], 'class': ['card shadow-sm p-4', 'card shadow-sm']}]}

        findS['last_page'] = {}
        if findS['controls'].get('force_find_last_page'): del findS['controls']['force_find_last_page']
    
    return AlfaChannel.list_all(item, matches_post=list_all_matches, generictools=True, finds=findS, **kwargs)


def list_all_matches(item, matches_int, **AHkwargs):
    logger.info()

    matches = []
    findS = AHkwargs.get('finds', finds)

    for elem in matches_int:
        elem_json = {}
        #logger.error(elem)

        if item.extra in ['novedades']:
            for elem_a in elem.find_all('a', class_='text-primary'):
                elem_json = {}
                #logger.error(elem_a)

                try:
                    elem_json['url'] = elem_a.get("href", "")
                    if not elem_json['url'].startswith('http') and not elem_json['url'].startswith('/'):
                        elem_json['url'] = '/%s' % elem_json['url']
                    if (movie_path not in elem_json['url'] and tv_path not in elem_json['url'] \
                                   and docu_path not in elem_json['url']) or tienda_path in elem_json['url']: continue
                    #logger.error(elem_a)
                    
                    elem_json['title'] = elem_a.get_text(strip=True)
                    if scrapertools.find_single_match(elem_json['title'], r'(?i)\:?\s*(\d+x\d+)'):
                        elem_json['title_subs'] = ["Episodio %s" % scrapertools.find_single_match(elem_json['title'], r'(?i)\:?\s*(\d+x\d+)')]
                    elem_json['title'] = re.sub(r'(?i)\:?\s*\d+x\d+','', elem_json['title'])

                    if movie_path in elem_json['url']:
                        elem_json['quality'] = '*%s' % re.sub(r'(?i)\(|\)|Ninguno', '', 
                                                elem_a.find_next_sibling('span', class_='text-muted').get_text(strip=True))
                        elem_json['title'] = re.sub(r'\[([^\]]+)\]', '', elem_json['title'])
                        elem_json['title'] = re.sub(r'(?i)\s*\[*\(*(?:3d|4k)\)*\]*', '', elem_json['title'])
                    elif tv_path in elem_json['url']:
                        elem_json['quality'] = scrapertools.find_single_match(elem_json['title'], r'\[([^\]]+)\]')
                        elem_json['quality'] = 'HDTV-720p' if '720p' in elem_json['quality'] else 'HDTV'
                    if '3d' in elem_json['title'].lower() and '3d' not in elem_json['quality'].lower():
                        elem_json['quality'] = '%s,3d' % elem_json['quality']

                except Exception:
                    logger.error(elem_a)
                    logger.error(traceback.format_exc())
                    continue

                if not elem_json.get('url'): continue
                if item.title == 'Películas' and movie_path not in elem_json['url']: continue
                if item.title == 'Series' and tv_path not in elem_json['url']: continue
                if item.title == 'Documentales' and docu_path not in elem_json['url']: continue

                matches.append(elem_json.copy())

        elif item.extra in ['Alfabético'] and item.c_type == 'series':
            for elem_a in elem.find_all('p'):
                elem_json = {}
                #logger.error(elem_a)

                try:
                    if not elem_a.find('a'): continue
                    elem_json['url'] = elem_a.a.get("href", "")
                    elem_json['title'] = elem_a.get_text('|', strip=True)
                    elem_json['quality'] = '*%s' % (scrapertools.find_single_match(elem_a.get_text('|', strip=True), 
                                                                r'\[([^\]]+)\]').replace('Subs. integrados', '').strip() or 'HDTV')
                    elem_json['quality'] = 'HDTV-720p' if '720p' in elem_json['quality'] else 'HDTV'
                    elem_json['language'] = '*'

                except Exception:
                    logger.error(elem_a)
                    logger.error(traceback.format_exc())
                    continue

                if not elem_json.get('url') or tienda_path in elem_json['url'] \
                                            or (item.quality and '720p' not in item.quality \
                                                and elem_json['quality'].replace('*', '') != item.quality): continue

                matches.append(elem_json.copy())
        
        elif item.extra in ['Géneros', 'Year', 'Quality'] :
            for elem_a in elem.find_all('a', class_='position-relative'):
                elem_json = {}
                #logger.error(elem_a)

                try:
                    elem_json['url'] = elem_a.get("href", "")
                    if movie_path not in elem_json['url'] and tv_path not in elem_json['url']: continue
                    info = AlfaChannel.do_soup(elem_a.get("data-content", ""))
                    elem_json['title'] = info.find('p', class_='lead text-dark mb-0').get_text(strip=True)
                    elem_json['plot'] = info.find('hr', class_='my-2').find_next('p').get_text(strip=True)
                    elem_json['thumbnail'] = elem_a.img.get("src", "")
                    elem_json['quality'] = '*%s' % re.sub(r'(?i)\(|\)|Ninguno', '', elem_a.get_text(strip=True))
                    if tv_path in elem_json['url']:
                        elem_json['quality'] = 'HDTV-720p' if '720p' in elem_json['quality'] else 'HDTV'
                    elem_json['language'] = '*'

                except Exception:
                    logger.error(elem_a)
                    logger.error(traceback.format_exc())
                    continue

                if not elem_json.get('url'): continue
                if item.c_type == 'peliculas' and tv_path in elem_json['url']: continue
                if item.c_type == 'series' and movie_path in elem_json['url']: continue

                matches.append(elem_json.copy())

        elif item.c_type in ['search']:
            try:
                items_found = int(elem.find('p', class_="lead").find_next('p', class_="lead").get_text('|', strip=True).split('|')[1])
            except Exception:
                items_found = 0
            items_found_save = items_found

            for elem_a in elem.find_all('p'):
                elem_json = {}
                #logger.error(elem_a)

                try:
                    if not elem_a.find('a'): continue
                    elem_json['url'] = elem_a.find('a').get("href", "")
                    if items_found > 0: items_found -= 1
                    if movie_path not in elem_json['url'] and tv_path not in elem_json['url'] and docu_path not in elem_json['url']: continue
                    if movie_path in elem_json['url']:
                        elem_json['title'] = (elem_a.get_text('|').split('|')[0] + elem_a.get_text('|').split('|')[1]).rstrip('.')
                        elem_json['quality'] = '*%s' % scrapertools.find_single_match(elem_a.get_text('|').split('|')[-2], 
                                                                                                      r'\((.*?)\)').replace('Ninguno', '')
                    else:
                        elem_json['title'] = re.sub(r'(?i)\s*\(.*?\).*?$', '', elem_a.get_text()).rstrip('.')
                        elem_json['quality'] = '*%s' % scrapertools.find_single_match(elem_a.get_text(), r'\((.*?)\)').replace('Ninguno', '')
                        elem_json['quality'] = 'HDTV-720p' if '720p' in elem_json['quality'] else 'HDTV'
                    if '3d' in elem_json['title'].lower() and '3d' not in elem_json['quality'].lower():
                        elem_json['quality'] = '%s,3d' % elem_json['quality']
                    elem_json['language'] = '*'
                    if movie_path in elem_json['url']: elem_json['title'] = re.sub(r'(?i)\s*\[*\(*(?:3d|4k)\)*\]*', '', elem_json['title'])

                except Exception:
                    logger.error(elem_a)
                    logger.error(traceback.format_exc())
                    continue

                if not elem_json.get('url'): continue

                matches.append(elem_json.copy())

            if AlfaChannel.last_page in [9999, 99999] and items_found:
                AlfaChannel.last_page = int(float(items_found_save / float(findS['controls']['cnt_tot'])  + 0.500009))
                AlfaChannel.cnt_tot = items_found_save

        elif item.c_type in ['peliculas', 'series']:
            for elem_a in elem.find_all('a'):
                elem_json = {}
                #logger.error(elem_a)
                
                try:
                    elem_json['url'] = elem_a.get("href", "")
                    if tienda_path in elem_json['url']: continue
                    elem_json['thumbnail'] = elem_json['title'] = elem_a.img.get("src", "") if elem_a.img else ''
                    elem_json['quality'] = item.quality
                    elem_json['language'] = '*CAST'
                    
                    if movie_path in elem_json['url']:
                        # Si es Película obtenermos el título a partir del Thumbnail
                        elem_json['title'] = scrapertools.remove_htmltags(elem_json['title']).strip().strip('.')
                        elem_json['title'] = re.sub(r'\d{3,7}[-|_|\/]+\d{3,10}[-|\/]', '', elem_json['title'].split('/')[-1])
                        elem_json['title'] = re.sub(r'--[^\.|$]*|.jpg|.png|$', '', elem_json['title'])
                        elem_json['title'] = re.sub(r'-\d{6,10}-mmed(?:.jpg|.png|$)', '', elem_json['title'])
                        elem_json['title'] = re.sub(r'(?i)\s*\[*\(*(?:3d|4k)\)*\]*', '', elem_json['title'])
                        elem_json['title'] = elem_json['title'].replace('-', ' ').replace('_', ' ').strip()
                    
                    else:
                        # Si es Serie o Documental obtenermos el título a partir de la url
                        if scrapertools.find_single_match(elem_json['url'], r'[-|\/]\d{3,10}[-|\/]\d{3,10}[-|\/]*(.*?)(?:.htm|$)'):
                            elem_json['title'] = scrapertools.find_single_match(elem_json['url'], 
                                                 r'[-|\/]\d{3,10}[-|\/]\d{3,10}[-|\/]*(.*?)(?:.htm|$)').replace('-', ' ').replace('_', ' ')
                            elem_json['title'] = re.sub(r'\d+\s*[t|T]emporada', '', elem_json['title'])
                        else:
                            elem_json['title'] = scrapertools.find_single_match(elem_json['url'], 
                                                 r'[-|\/]\d{3,10}[-|\/](.*?)(?:.htm|$)').replace('-', ' ').replace('_', ' ')
                        elem_json['title'] = re.sub(r'(?i)\s*-\s*\d{1,2}.\s*temporada\s*(?:\[.*?\])?', '', elem_json['title']).rstrip('.')
                        if not elem_json['title']:
                            elem_json['title'] = elem_json['url']
                        elem_json['title'] = scrapertools.remove_htmltags(elem_json['title'])
                    if '3d' in elem_json['title'].lower() and '3d' not in elem_json['quality'].lower():
                        elem_json['quality'] = '%s,3d' % elem_json['quality']

                except Exception:
                    logger.error(elem_a)
                    logger.error(traceback.format_exc())
                    continue
                
                if not elem_json.get('url'): continue
                if item.c_type == 'peliculas' and (tv_path in elem_json['url'] or docu_path in elem_json['url']): continue
                if item.c_type == 'series' and movie_path in elem_json['url']: continue

                matches.append(elem_json.copy())

    return matches

def seasons(item):
    logger.info()

    kwargs['headers'] = {'Referer': item.url}

    return AlfaChannel.seasons(item, **kwargs)


def episodios(item):
    logger.info()

    itemlist = []

    templist = seasons(item)

    for tempitem in templist:
        itemlist += episodesxseason(tempitem)

    return itemlist


def episodesxseason(item):
    logger.info()

    kwargs['headers'] = {'Referer': item.url}
    kwargs['matches_post_get_video_options'] = findvideos_matches

    return AlfaChannel.episodes(item, matches_post=episodesxseason_matches, generictools=True, finds=finds, **kwargs)


def episodesxseason_matches(item, matches_int, **AHkwargs):
    logger.info()

    matches = []
    findS = AHkwargs.get('finds', finds)

    for elem in matches_int:
        elem_json = {}
        #logger.error(elem)

        for x, td in enumerate(elem.find_all('td')):
            #logger.error(td)

            if x == 0: 
                epi_rango = False
                error = False
                alt_epi = 0
                try:
                    sxe = td.get_text(strip=True)
                    if not sxe: break
                    if scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*al\s*\d+x(\d+)'):
                        elem_json['season'], elem_json['episode'], alt_epi = \
                                scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*al\s*\d+x(\d+)')
                        epi_rango = True
                    elif scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*al\s*(\d+)'):
                        elem_json['season'], elem_json['episode'], alt_epi = \
                                scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*al\s*(\d+)')
                        epi_rango = True
                    elif scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*-\s*\d+x(\d+)'):
                        elem_json['season'], elem_json['episode'], alt_epi = \
                                scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*-\s*\d+x(\d+)')
                        epi_rango = True
                    elif scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*-\s*(\d+)'):
                        elem_json['season'], elem_json['episode'], alt_epi = \
                                scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)\s*-\s*(\d+)')
                        epi_rango = True
                    elif scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)'):
                        elem_json['season'], elem_json['episode'] = \
                                scrapertools.find_single_match(sxe, r'(?i)(\d+)x(\d+)')
                    elif scrapertools.find_single_match(sxe, r'(\d+)'):
                        elem_json['season'] = 1
                        elem_json['episode'] = scrapertools.find_single_match(sxe, r'^(\d+)')
                    elif scrapertools.find_single_match(sxe, r'(?i)\[cap\.(\d)(\d{2})\]'):
                        continue
                    else:
                        break
                    elem_json['season'] = contentSeason = int(elem_json['season'])
                    elem_json['episode'] = int(elem_json['episode'])
                    alt_epi = int(alt_epi)
                except Exception:
                    logger.error('ERROR al extraer Temporada/Episodio: %s' % sxe)
                    logger.error(td)
                    logger.error(traceback.format_exc())
                    elem_json['season'] = contentSeason = 1
                    elem_json['episode'] = 1
                    error = True
                
                if epi_rango:                                                   # Si son episodios múltiples, lo guardamos
                    elem_json['title'] = 'al %s' % str(alt_epi).zfill(2)

            if x == 1:
                elem_json['url'] = td.a.get('href', '')
                if not elem_json['url'] and td.find('a', class_='bg-primary') and td.find('a', class_='bg-primary').get('data-content-id'):
                    elem_json['matches_verify'] = True
                    elem_json['url'] = item.url
                    elem_json['info'] = '{"action":"generate","content_id":%s,"tabla":"%s"}' \
                                          % (int(elem.find('a', class_='bg-primary').get('data-content-id', 0)), 
                                             elem.find('a', class_='bg-primary').get('data-tabla', 'peliculas'))
                if error and docu_path not in elem_json['url']: break
                if elem_json['url'].startswith('//'):
                    elem_json['url'] = 'https:%s' % elem_json['url']
                elem_json['quality'] = '*%s' % (scrapertools.find_single_match(elem_json['url'], 
                                               r'[-|_]\(?\[?((?:HDTV\d{3,4}p|720p|1080p|HDTV)(?:[-|_]\d+p)?)').replace('_', '-') or item.quality)

            if x == 3:
                if 'copiar' in td.a.get('title', ''):
                    info = AlfaChannel.do_soup(td.a.get('title', ''))
                    if info and info.a: elem_json['password'] = info.a.get('data-clave', '')

        if not elem_json.get('url', ''):
            continue
        if docu_path not in elem_json['url'] and elem_json.get('season', 0) != item.contentSeason:
            continue

        elem_json['server'] = 'torrent'
        elem_json['language'] = '*'
        elem_json['size'] = ''
        elem_json['torrent_info'] = ''
        elem_json['title'] = elem_json.get('title', '')
        elem_json['quality'] = AlfaChannel.find_quality(elem_json, item)

        matches.append(elem_json.copy())
    
    return matches


def findvideos(item):
    logger.info()

    kwargs['headers'] = {'Referer': item.url}
    kwargs['matches_post_episodes'] = episodesxseason_matches

    return AlfaChannel.get_video_options(item, item.url, matches_post=findvideos_matches, 
                                         verify_links=False, generictools=True, findvideos_proc=True, **kwargs)


def findvideos_matches(item, matches_int, langs, response, **AHkwargs):
    logger.info()

    matches = []
    findS = AHkwargs.get('finds', finds)
    videolibrary = AHkwargs.get('videolibrary', False)

    if videolibrary:
        for x, (scrapedtitle, scrapedurl, scrapedpassword, scrapedquality) in enumerate(matches_int):
            elem_json = {}
            #logger.error(matches_int[x])

            if item.infoLabels['mediatype'] in ['episode']:
                elem_json['season'] = item.infoLabels['season']
                elem_json['episode'] = item.infoLabels['episode']

            elem_json['url'] = scrapedurl
            elem_json['title'] = scrapedtitle
            if 'magnet' in elem_json['url']:
                elem_json['torrent_info'] = scrapedpassword
            else:
                if scrapedpassword: elem_json['password'] = scrapedpassword
                elem_json['torrent_info'] = ''
            elem_json['quality'] = '*%s' % scrapedquality
            elem_json['server'] = 'torrent'
            elem_json['language'] = '*CAST'

            matches.append(elem_json.copy())
            item.emergency_urls[1][x] = elem_json.copy()

    else:
        for elem in matches_int:
            elem_json = {}
            #logger.error(elem)

            try:
                elem_json['url'] = ''
                if elem.find('a', class_='bg-primary') and elem.find('a', class_='bg-primary').get('href'):
                    elem_json['url'] = elem.find('a', class_='bg-primary').get('href', '')

                elif elem.find('a', class_='bg-primary') and elem.find('a', class_='bg-primary').get('data-content-id'):
                    elem_json['url'] = host + torrent_path
                    elem_json['info'] = item.info or '{"action":"generate","content_id":%s,"tabla":"%s"}' \
                                                      % (int(elem.find('a', class_='bg-primary').get('data-content-id', 0)), 
                                                         elem.find('a', class_='bg-primary').get('data-tabla', 'peliculas'))
                    elem_json['url'] = find_torrent(item, elem_json)
                else:
                    continue

                elem_json['quality'] = '*%s' % elem.find('b', class_='bold', string=re.compile('Formato:'))\
                                                   .find_previous('p').get_text('|', strip=True).split('|')[1]
                if '3d' in elem_json['url'].lower() and '3d' not in elem_json['quality'].lower():
                        elem_json['quality'] = '%s,3d' % elem_json['quality']

                if elem.find('b', class_='bold', string=re.compile('Clave:\s*')):
                    elem_json['password'] = elem.find('b', class_='bold', string=re.compile('Clave:\s*'))\
                                                .find_next('a').get('data-content', '')
                    elem_json['password'] = item.password = scrapertools.find_single_match(elem_json['password'], "value='([^']+)'")
            except Exception:
                logger.error(elem)
                logger.error(traceback.format_exc())
                continue
            
            elem_json['server'] = 'torrent'
            elem_json['language'] = '*CAST'
            elem_json['torrent_info'] = ''
            
            if not elem_json.get('url', ''): continue

            matches.append(elem_json.copy())

    return matches, langs


def actualizar_titulos(item):
    logger.info()
    #Llamamos al método que actualiza el título con tmdb.find_and_set_infoLabels

    return AlfaChannel.do_actualizar_titulos(item)


def find_torrent(item, elem_json):
    import hashlib

    kwargs = {'set_tls': True, 'set_tls_min': True, 'retries_cloudflare': 0, 'ignore_response_code': True, 
              'timeout': 5, 'cf_assistant': False, 'hide_infobox': True, 'canonical': {}, 'json': True, 'soup': False}
    kwargs['headers'] = {'Referer': item.url, 'Content-Type': 'application/json'}
    kwargs['post'] = elem_json['info']
    elem_json['url'] = host + torrent_path

    def nonce_gen(challenge, difficulty=3):
        nonce = 0
        target = '0' * difficulty

        while True:
            text = challenge + str(nonce)
            hash_hex = hashlib.sha256(text.encode()).hexdigest()

            if hash_hex.startswith(target):
                return nonce

            nonce += 1

            # Yield to event loop to avoid blocking
            if nonce % 1000 == 0:
                time.sleep(0.1)

    json = AlfaChannel.create_soup(elem_json['url'], **kwargs)
    if isinstance(json, _dict) and json.get('success') and json.get('challenge'):
        kwargs['post'] = '{"action":"validate","challenge":"%s","nonce":%s}' % (json['challenge'], nonce_gen(json['challenge']))

        json = AlfaChannel.create_soup(elem_json['url'], **kwargs)
        if isinstance(json, _dict) and json.get('success') and json.get('download_url'):
            elem_json['url'] = json['download_url']
            if not elem_json['url'].startswith('http'):
                elem_json['url'] = 'https:%s' % elem_json['url']

            try:
                matches = (item.matches or [])[:]
                item.matches = []
                for match in matches:
                    if match.get('info', '') == elem_json['info']: continue
                    item.matches.append(match.copy())
            except Exception:
                logger.error(traceback.format_exc())

    return elem_json['url']


def search(item, texto, **AHkwargs):
    logger.info()
    kwargs.update(AHkwargs)

    texto = texto.replace(" ", "%20")

    try:
        if texto:
            if item.btdigg: item.btdigg = texto
            if not host_new:
                item.url = item.referer = host + 'buscar/' + texto
            else:
                item.url = item.referer = host + 'buscar'
                item.post = 'valor=%s&Buscar=Buscar' % texto
            item.c_type = "search"
            item.texto = texto
            return list_all(item)
        else:
            return []
    except Exception:
        for line in sys.exc_info():
            logger.error("%s" % line)
        logger.error(traceback.format_exc())
        return []
 
 
def newest(categoria, **AHkwargs):
    logger.info()
    kwargs.update(AHkwargs)

    itemlist = []
    item = Item()

    item.title = "newest"
    item.category_new = "newest"
    item.channel = channel

    try:
        if categoria in ['peliculas', 'series']:
            item.url = host + "ultimos"
            item.c_type = categoria
            item.extra = "novedades"
            item.action = "list_all"
            itemlist = list_all(item)

        if len(itemlist) > 0 and ">> Página siguiente" in itemlist[-1].title:
            itemlist.pop()

    # Se captura la excepción, para no interrumpir al canal novedades si un canal falla
    except Exception:
        for line in sys.exc_info():
            logger.error("{0}".format(line))
        logger.error(traceback.format_exc())
        return []

    return itemlist
